/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.animation;

import icyllis.modernui.animation.Interpolator;

public class ViscousFluidInterpolator
implements Interpolator {
    private static final float VISCOUS_FLUID_SCALE = 8.0f;
    private static final float VISCOUS_FLUID_NORMALIZE = 1.0f / ViscousFluidInterpolator.viscousFluid(1.0f);
    private static final float VISCOUS_FLUID_OFFSET = 1.0f - VISCOUS_FLUID_NORMALIZE * ViscousFluidInterpolator.viscousFluid(1.0f);
    private static final float START = 0.36787945f;

    ViscousFluidInterpolator() {
    }

    private static float viscousFluid(float x) {
        if ((x *= 8.0f) < 1.0f) {
            x -= 1.0f - (float)Math.exp(-x);
        } else {
            x = 1.0f - (float)Math.exp(1.0f - x);
            x = 0.36787945f + x * 0.63212055f;
        }
        return x;
    }

    @Override
    public float getInterpolation(float progress) {
        float v = VISCOUS_FLUID_NORMALIZE * ViscousFluidInterpolator.viscousFluid(progress);
        if (v > 0.0f) {
            return v + VISCOUS_FLUID_OFFSET;
        }
        return v;
    }
}

